/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.state;

import java.awt.Color;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.autoplot.RenderType;
import org.autoplot.dom.Application;
import org.autoplot.dom.Axis;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.Column;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.Row;
import org.autoplot.state.AbstractVapScheme;
import org.autoplot.state.SerializeUtil;
import org.autoplot.state.Vap1_06Scheme;
import org.autoplot.state.Vap1_07Scheme;
import org.autoplot.state.Vap1_08Scheme;
import org.autoplot.state.Vap1_09Scheme;
import org.das2.qstream.SerializeDelegate;
import org.das2.qstream.SerializeRegistry;
import org.das2.util.AboutUtil;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StatePersistence {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom.vap");

    private StatePersistence() {
    }

    public static AbstractVapScheme currentScheme() {
        return new Vap1_08Scheme();
    }

    public static void saveState(File f, Object state) throws IOException {
        StatePersistence.saveState(new FileOutputStream(f), state, "");
    }

    public static void saveState(File f, Object state, String sscheme) throws IOException {
        StatePersistence.saveState(new FileOutputStream(f), state, sscheme);
    }

    public static void saveState(OutputStream out, Object state, String sscheme) throws IOException {
        AbstractVapScheme scheme;
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        Vap1_09Scheme currentScheme = new Vap1_09Scheme();
        switch (sscheme) {
            case "": {
                scheme = new Vap1_08Scheme();
                break;
            }
            case "1.09": {
                scheme = new Vap1_09Scheme();
                break;
            }
            case "1.08": {
                scheme = new Vap1_08Scheme();
                break;
            }
            case "1.07": {
                scheme = new Vap1_07Scheme();
                break;
            }
            case "1.06": {
                scheme = new Vap1_06Scheme();
                break;
            }
            default: {
                throw new IllegalArgumentException("output scheme not supported: " + sscheme);
            }
        }
        if (scheme.getId().equals("1.08") && currentScheme.getId().equals("1.09")) {
            boolean removedBindings = false;
            Application app = (Application)state;
            ArrayList<BindingModel> newbms = new ArrayList<BindingModel>(Arrays.asList(app.getBindings()));
            for (int i = app.getBindings().length - 1; i >= 0; --i) {
                if (!app.getBindings(i).getSrcProperty().equals("scale") && !app.getBindings(i).getDstProperty().equals("scale")) continue;
                newbms.remove(i);
                removedBindings = true;
            }
            if (removedBindings) {
                logger.warning("removing all bindings to scale to support old versions");
                app.setBindings(newbms.toArray(new BindingModel[newbms.size()]));
            }
        }
        Element element = SerializeUtil.getDomElement(document, (DomNode)state, scheme, true);
        Element vap = document.createElement("vap");
        vap.appendChild(element);
        vap.setAttribute("domVersion", scheme.getId());
        vap.setAttribute("appVersionTag", AboutUtil.getReleaseTag());
        document.appendChild(vap);
        if (!scheme.getId().equals(currentScheme.getId())) {
            try {
                logger.log(Level.INFO, "converting from vap version {0} to {1}", new Object[]{currentScheme.getId(), scheme.getId()});
                StatePersistence.doConvert(document, currentScheme.getId(), scheme.getId());
            }
            catch (TransformerException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                IOException result = new IOException("Unable to export to version " + sscheme, ex);
                throw result;
            }
        }
        StatePersistence.writeDocument(out, document);
    }

    public static void writeDocument(OutputStream out, Document document) throws IOException {
        DOMImplementation impl = document.getImplementation();
        DOMImplementationLS ls = (DOMImplementationLS)impl.getFeature("LS", "3.0");
        LSSerializer serializer = ls.createLSSerializer();
        LSOutput output = ls.createLSOutput();
        output.setEncoding("UTF-8");
        output.setByteStream(out);
        try {
            if (serializer.getDomConfig().canSetParameter("format-pretty-print", Boolean.TRUE)) {
                serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            }
        }
        catch (Error e2) {
            logger.log(Level.WARNING, e2.getMessage(), e2);
        }
        serializer.write(document, output);
        out.close();
    }

    public static void writeDocument(File f, Document document) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(f);
        StatePersistence.writeDocument(out, document);
    }

    public static Element getChildElement(Element parent, String tagName) {
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if (!(item instanceof Element) || !((Element)item).getTagName().equals(tagName)) continue;
            return (Element)item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object restoreState(File f) throws IOException {
        Application result;
        try (FileInputStream in = new FileInputStream(f);){
            LinkedHashMap<String, String> macros = new LinkedHashMap<String, String>();
            String pwd = "file:" + f.getParent() + "/";
            macros.put("PWD", pwd);
            result = StatePersistence.restoreState(in, macros);
        }
        return result;
    }

    private static Document doConvert(Document document, String domVersion, String currentVersion) throws TransformerConfigurationException, TransformerException {
        double dstVersion;
        double srcVersion = Double.parseDouble(domVersion);
        if (srcVersion > (dstVersion = Double.parseDouble(currentVersion))) {
            for (double s = srcVersion; s > dstVersion; s -= 0.01) {
                DOMSource src = new DOMSource(document);
                DOMResult res = new DOMResult();
                String fname = String.format(Locale.US, "Vap_%4.2f_to_%4.2f", s, s - 0.01);
                InputStream xsl = StatePersistence.class.getResourceAsStream(fname = fname.replaceAll("\\.", "_") + ".xsl");
                if (xsl == null) {
                    throw new RuntimeException("Unable to find " + fname + ".");
                }
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer tr = factory.newTransformer(new StreamSource(xsl));
                tr.transform(src, res);
                document = (Document)res.getNode();
            }
        }
        return document;
    }

    private static Application readLegacyFile(Document document) throws IOException {
        Application state;
        StatePersistence.importLegacyVap(document.getDocumentElement());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
        logger.info("importing legacy vap file v0.99. ");
        logger.info("These must be rewritten to new vap format, support will be dropped.");
        DOMImplementation impl = document.getImplementation();
        DOMImplementationLS ls = (DOMImplementationLS)impl.getFeature("LS", "3.0");
        LSSerializer serializer = ls.createLSSerializer();
        LSOutput output = ls.createLSOutput();
        output.setEncoding("UTF-8");
        output.setByteStream(baos);
        serializer.write(document, output);
        baos.close();
        XMLDecoder decode = new XMLDecoder(new ByteArrayInputStream(baos.toByteArray()));
        Application app = state = (Application)decode.readObject();
        for (PlotElement plotElement : app.getPlotElements()) {
            if (plotElement.getRenderType() != null) continue;
            plotElement.setRenderTypeAutomatically(RenderType.series);
        }
        for (DomNode domNode : app.getPlots()) {
            ((Plot)domNode).getZaxis().setVisible(false);
            List<PlotElement> pes = DomUtil.getPlotElementsFor(app, (Plot)domNode);
            for (PlotElement pe : pes) {
                RenderType rt = pe.getRenderType();
                if (rt != RenderType.spectrogram && rt != RenderType.nnSpectrogram && rt != RenderType.colorScatter) continue;
                ((Plot)domNode).getZaxis().setVisible(true);
            }
        }
        return state;
    }

    private static void doBindings(Application state) {
        for (BindingModel m : state.getBindings()) {
            DomNode src = DomUtil.getElementById(state, m.getSrcId());
            DomNode dst = DomUtil.getElementById(state, m.getDstId());
            AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)src, (Property)BeanProperty.create((String)m.getSrcProperty()), (Object)dst, (Property)BeanProperty.create((String)m.getDstProperty()));
            binding.bind();
        }
    }

    private static void makeValid(Application state) {
        if (state.getController() != null) {
            throw new IllegalArgumentException("state must not have controller");
        }
        Canvas c = state.getCanvases(0);
        if (c.getMarginRow().getId().equals("")) {
            c.getMarginRow().setId("marginRow_0");
        }
        if (c.getMarginColumn().getId().equals("")) {
            c.getMarginColumn().setId("marginColumn_0");
        }
        for (Column col : state.getCanvases(0).getColumns()) {
            if (!col.getParent().equals(c.getMarginRow().getId())) continue;
            col.setParent(c.getMarginColumn().getId());
        }
        if (state.getPlots(0).getRowId().equals("")) {
            int n = state.getPlots().length;
            Row[] rows = new Row[n];
            for (int i = 0; i < n; ++i) {
                Row r = new Row();
                r.setBottom("" + (double)((i + 1) * 10000) / 100.0 / (double)n + "%-2.0em");
                r.setTop("" + (double)(i * 10000) / 100.0 / (double)n + "%+2.0em");
                r.setParent(c.getMarginRow().getId());
                r.setId("row_" + i);
                state.getPlots(i).setRowId(r.getId());
                state.getPlots(i).setColumnId(c.getMarginColumn().getId());
                rows[i] = r;
            }
            c.setRows(rows);
        }
        Color foreground = state.getOptions().getForeground();
        for (BindingModel m : state.getBindings()) {
            DomNode src = DomUtil.getElementById(state, m.getSrcId());
            if (src == null) {
                logger.log(Level.WARNING, "invalid binding:{0}, unable to find source node: {1}", new Object[]{m, m.getSrcId()});
                continue;
            }
            DomNode dst = DomUtil.getElementById(state, m.getDstId());
            if (dst == null) {
                logger.log(Level.WARNING, "invalid binding:{0}, unable to find destination node: {1}", new Object[]{m, m.getDstId()});
                continue;
            }
            BeanProperty srcProp = BeanProperty.create((String)m.getSrcProperty());
            BeanProperty dstProp = BeanProperty.create((String)m.getDstProperty());
            if (!srcProp.isReadable((Object)src)) {
                logger.log(Level.WARNING, "invalid binding:{0}, unable to find source property: {1}", new Object[]{m, m.getSrcProperty()});
                continue;
            }
            if (!dstProp.isReadable((Object)dst)) {
                logger.log(Level.WARNING, "invalid binding:{0}, unable to find destination property: {1}", new Object[]{m, m.getSrcProperty()});
                continue;
            }
            Object srcVal = srcProp.getValue((Object)src);
            Object dstVal = dstProp.getValue((Object)dst);
            if (srcVal == null && dstVal == null || srcVal == null || dstVal == null || srcVal.equals(dstVal)) continue;
            if (dst instanceof Axis && m.getDstProperty().equals("range") && ((Axis)dst).isAutoRange()) {
                logger.log(Level.FINE, "fixing inconsistent vap where bound values were not equal: {0}.{1}!={2}.{3}", new Object[]{m.getSrcId(), m.getSrcProperty(), m.getDstId(), m.getDstProperty()});
            } else {
                logger.log(Level.WARNING, "fixing inconsistent vap where bound values were not equal: {0}.{1}!={2}.{3}", new Object[]{m.getSrcId(), m.getSrcProperty(), m.getDstId(), m.getDstProperty()});
            }
            BeanProperty.create((String)m.getDstProperty()).setValue((Object)dst, srcVal);
        }
        DomUtil.deleteDuplicateIds(state);
    }

    public static Application restoreState(InputStream in, LinkedHashMap<String, String> deltas) throws IOException {
        Application state = (Application)StatePersistence.restoreState(in);
        List<String> problems = DomUtil.checkUniqueIdsAndReferences(state, new ArrayList<String>());
        if (!problems.isEmpty()) {
            for (String string : problems) {
                logger.warning(string);
            }
        }
        StatePersistence.makeValid(state);
        if (deltas != null) {
            StatePersistence.doBindings(state);
            for (Map.Entry entry : deltas.entrySet()) {
                Class c;
                logger.log(Level.FINEST, "applying to vap {0}={1}", new Object[]{entry.getKey(), entry.getValue()});
                String node = (String)entry.getKey();
                String sval = (String)entry.getValue();
                if (node.contains("%{") || sval.contains("%{")) {
                    logger.info("ignoring macro which contains '%{' in the name or the value");
                    continue;
                }
                if (Character.isUpperCase(node.charAt(0))) {
                    DomUtil.applyMacro(state, "%{" + node + "}", sval);
                    continue;
                }
                try {
                    c = DomUtil.getPropertyType(state, node);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    continue;
                }
                SerializeDelegate sd = SerializeRegistry.getDelegate((Class)c);
                if (sd == null) {
                    System.err.println("unable to find serialize delegate for " + c.getCanonicalName());
                    continue;
                }
                try {
                    if (sval.length() > 1 && sval.startsWith("'") && sval.endsWith("'")) {
                        sval = sval.substring(1, sval.length() - 1);
                    }
                    Object val = sd.parse(sd.typeId(c), sval);
                    DomUtil.setPropertyValue(state, node, val);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                catch (ParseException ex) {
                    IOException ioex = new IOException(ex.getMessage());
                    throw ioex;
                }
            }
        }
        return state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object restoreState(InputStream in) throws IOException {
        PushbackInputStream pbin = new PushbackInputStream(in, 10);
        int available = pbin.available();
        logger.log(Level.FINER, "available bytes in stream: {0}", available);
        if (available < 5) {
            throw new IllegalArgumentException("expected to find file that contained at least 5 characters");
        }
        byte[] five = new byte[5];
        for (int bytesRead = pbin.read(five); bytesRead < 5; bytesRead += pbin.read(five, bytesRead, 5 - bytesRead)) {
        }
        String magic = new String(five);
        if (!(magic.equals("<?xml") || magic.equals("<vap ") || magic.equals("<java"))) {
            throw new IllegalArgumentException("expected to find document that started with \"<?xml\" , this starts with \"" + magic + "\".");
        }
        pbin.unread(five);
        InputStreamReader isr = new InputStreamReader((InputStream)pbin, "UTF-8");
        try {
            Application state;
            String domVersion;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(isr);
            Document document = builder.parse(source);
            if (document.getDocumentElement().getNodeName().equals("java")) {
                domVersion = "0.99";
                state = StatePersistence.readLegacyFile(document);
            } else {
                Element root = document.getDocumentElement();
                if (root.getNodeName().equals("exceptionReport")) {
                    NodeList maybeVap = root.getElementsByTagName("vap");
                    if (maybeVap.getLength() != 1) throw new IllegalArgumentException("exception report doesn't have vap node");
                    root = (Element)maybeVap.item(0);
                } else if (!root.getNodeName().equals("vap")) {
                    throw new IllegalArgumentException("content should be a .vap file, an xml file with vap for the root node.");
                }
                domVersion = root.getAttribute("domVersion");
                String currentVersion = StatePersistence.currentScheme().getId();
                if (domVersion.startsWith("v")) {
                    domVersion = domVersion.substring(1).replace('_', '.');
                }
                if (!domVersion.equals(currentVersion)) {
                    Transformer tr;
                    TransformerFactory factory;
                    InputStream xsl;
                    String fname;
                    DOMResult res;
                    DOMSource src;
                    double s;
                    double dstVersion;
                    double srcVersion = Double.parseDouble(domVersion);
                    if (srcVersion > (dstVersion = Double.parseDouble(currentVersion))) {
                        for (s = srcVersion; s > dstVersion; s -= 0.01) {
                            src = new DOMSource(root);
                            res = new DOMResult();
                            fname = String.format(Locale.US, "Vap_%4.2f_to_%4.2f", s, s - 0.01);
                            xsl = StatePersistence.class.getResourceAsStream(fname = fname.replaceAll("\\.", "_") + ".xsl");
                            if (xsl == null) {
                                String vv = new Formatter().format(Locale.US, "%.2f", srcVersion).toString();
                                throw new RuntimeException("Unable to read .vap file version " + vv + ".  Upgrade to a newer version of Autoplot.");
                            }
                            factory = TransformerFactory.newInstance();
                            tr = factory.newTransformer(new StreamSource(xsl));
                            tr.transform(src, res);
                            root = (Element)res.getNode().getFirstChild();
                        }
                    } else {
                        for (s = srcVersion; s < dstVersion; s += 0.01) {
                            src = new DOMSource(root);
                            res = new DOMResult();
                            fname = String.format(Locale.US, "Vap_%4.2f_to_%4.2f", s, s + 0.01);
                            xsl = StatePersistence.class.getResourceAsStream(fname = fname.replaceAll("\\.", "_") + ".xsl");
                            if (xsl == null) {
                                throw new RuntimeException("Unable to find " + fname + ".");
                            }
                            factory = TransformerFactory.newInstance();
                            tr = factory.newTransformer(new StreamSource(xsl));
                            tr.transform(src, res);
                            root = (Element)res.getNode().getFirstChild();
                        }
                    }
                }
                Element dom = StatePersistence.getChildElement(root, "Application");
                state = (Application)SerializeUtil.getDomNode(dom, new Vap1_08Scheme());
            }
            if (domVersion.compareTo("1.00") < 0) {
                for (Plot pp1 : state.getPlots()) {
                    pp1.getXaxis().setAutoRange(true);
                    pp1.getYaxis().setAutoRange(true);
                    pp1.getZaxis().setAutoRange(true);
                }
                return state;
            } else {
                if (domVersion.compareTo("1.07") > 0) return state;
                logger.fine("clearing autorange property when loading vap file");
                for (Plot pp1 : state.getPlots()) {
                    if (!pp1.getXaxis().getAutoRangeHints().trim().isEmpty()) {
                        pp1.getXaxis().setAutoRange(false);
                    }
                    if (!pp1.getYaxis().getAutoRangeHints().trim().isEmpty()) {
                        pp1.getYaxis().setAutoRange(false);
                    }
                    if (pp1.getZaxis().getAutoRangeHints().trim().isEmpty()) continue;
                    pp1.getZaxis().setAutoRange(false);
                }
            }
            return state;
        }
        catch (ParseException | TransformerException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void importLegacyVap(Element element) {
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (true) {
            block19: {
                if (i >= nl.getLength()) {
                    return;
                }
                Node n = nl.item(i);
                switch (n.getNodeName()) {
                    case "void": {
                        NamedNodeMap nn = n.getAttributes();
                        Node prop = nn.getNamedItem("property");
                        if (prop == null) break;
                        if (prop.getNodeValue().equals("autorange")) {
                            prop.setNodeValue("autoRange");
                        }
                        if (prop.getNodeValue().equals("autolabel")) {
                            prop.setNodeValue("autoLabel");
                        }
                        if (prop.getNodeValue().equals("panels")) {
                            prop.setNodeValue("plotElements");
                        }
                        if (!prop.getNodeValue().equals("parentPanel")) break;
                        prop.setNodeValue("parent");
                        break;
                    }
                    case "object": {
                        NamedNodeMap nn = n.getAttributes();
                        Node prop = nn.getNamedItem("class");
                        if (prop != null) {
                            if (prop.getNodeValue().equals("org.virbo.autoplot.dom.Panel")) {
                                prop.setNodeValue("org.virbo.autoplot.dom.PlotElement");
                                break;
                            }
                            if (!prop.getNodeValue().equals("org.virbo.autoplot.dom.PanelStyle")) break;
                            prop.setNodeValue("org.virbo.autoplot.dom.PlotElementStyle");
                            break;
                        }
                        break block19;
                    }
                    case "array": {
                        NamedNodeMap nn = n.getAttributes();
                        Node prop = nn.getNamedItem("class");
                        if (prop == null) break block19;
                        if (prop.getNodeValue().equals("org.virbo.autoplot.dom.Panel")) {
                            prop.setNodeValue("org.virbo.autoplot.dom.PlotElement");
                            break;
                        }
                        if (!prop.getNodeValue().equals("org.virbo.autoplot.dom.PanelStyle")) break;
                        prop.setNodeValue("org.virbo.autoplot.dom.PlotElementStyle");
                    }
                }
                if (n.hasChildNodes() && n instanceof Element) {
                    StatePersistence.importLegacyVap((Element)n);
                }
            }
            ++i;
        }
    }
}

